import math
import collections

def median(l):
    data = sorted(l)
    n = len(data)
    if n == 0:
        return 0.0
    if n%2 == 1:
        return data[n//2]
    else:
        i = n//2
        return (data[i-1]+data[i])/2

'''file is formatted as .txt and contains export from FlowJo with GFP and Kappa levels for each Fo B cell event'''
'''make sure the desired FlowJo exports are in the same directory as this program'''

def reformatfile(filename):
    L1 = []
    L2 = []
    MedKappa = []
    GFPbins = []
    BinSize = []
    for n in range(0,10000,50):
        L1.append([n])
        '''This sets up a list that will later become a list of lists. These numbers correspond to each bin's GFP value'''
        '''This is where you can alter the size of the bins and the range of events that will be considered. If the 50 is altered, make sure to change how the index is calculated below.'''
    EventPairs = []
    file=open(filename,'r')
    for line in file:
        a = line.split('\r')
        for x in a:
            b = x.split('\t')
            try:
                float(b[1])
                EventPairs.append([float(b[0]),float(b[1])])
            except:
                pass
    for z in EventPairs:
        try:
            float(z[0])
            L1index = int(z[0]/50)
            '''This takes the GFP MFI (z[0]) for each event and calculates which bin (L1index) the event will go into'''
            L1[L1index].append(z[1])
            '''L1 is a list of lists; the first member of a list is the bin's GFP value, and all subsequent members are kappa MFIs for events that fall into that bin'''
        except:
            pass
    for y in L1:
        '''This is where we open up each bin, give the first element (GFP value) to a list of bins, and calculate the median of the remaining elements (kappa values for the bin) and give that to a list of kappa medians'''
        GFPbins.append(y[0])
        MedKappa.append(median(y[1:]))
        BinSize.append(len(y))
        '''This feature gives the size of the bin and can be used to identify empty bins'''
    print(MedKappa)
    print(GFPbins)
    print(BinSize)
